<x-guest-layout>
    <div class="flex items-center justify-center min-h-screen ">
        <div
            class="w-full max-w-2xl p-12 mx-4 text-center transition-all transform bg-white shadow-lg rounded-xl hover:shadow-xl">
            <!-- Success Icon -->
            <div class="flex items-center justify-center w-24 h-24 mx-auto mb-8 bg-green-100 rounded-full">
                <svg class="w-12 h-12 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                </svg>
            </div>

            <!-- Main Content -->
            <h1 class="mb-6 text-4xl font-extrabold text-green-600">
                @lang('app.payment-success')
            </h1>

            <p class="mb-8 text-xl text-gray-700">
                @lang('app.payment-success-message')
            </p>

            <div class="p-6 mb-8 rounded-lg bg-blue-50">
                <p class="text-lg font-medium text-blue-700">
                    @lang('app.peoples-travellers', ['peoples' => $booking->peoples])
                </p>
            </div>

            <!-- Contact Information -->
            <div class="pt-8 mt-8 border-t border-gray-100">
                <p class="text-lg text-gray-700">
                    @lang('app.have-questions')
                </p>
                <a href="mailto:admin@eliteai.tools"
                    class="inline-block mt-2 text-xl font-medium text-blue-600 transition-colors duration-200 hover:text-blue-800">
                    {{ $booking->agent?->email?? 'payment@bdtravel.test' }}
                </a>
            </div>

            <!-- Back to Home Button -->
            <div class="mt-12">
                <a href="{{url('user/dashboard')}}"
                    class="inline-block px-8 py-4 text-lg font-semibold text-white transition-colors duration-200 bg-green-600 rounded-lg hover:bg-green-700">
                    @lang('app.return-to-dashboard')
                </a>
            </div>
        </div>
    </div>
</x-guest-layout>
